#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "qcap.h"
#include "qcap.windef.h"


namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void HwInitialize();

    void HwUninitialize();

public:
    Ui::MainWindow *ui;

    PVOID				m_pDevice;

    PVOID				m_hNetworkServer;

    volatile ULONG		m_nNetworkServerState_audio;

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_audio;

    volatile ULONG		m_nNetworkServerState_video;

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_video;

    ULONG				m_nVideoWidth;

    ULONG				m_nVideoHeight;

    BOOL				m_bVideoIsInterleaved;

    double				m_dVideoFrameRate;

    ULONG				m_nAudioChannels;

    ULONG				m_nAudioBitsPerSample;

    ULONG				m_nAudioSampleFrequency;

    ULONG               m_nVideoInput;

    ULONG               m_nAudioInput;

private slots:

    void on_pushBTN_Input_clicked();

    void on_pushBTN_Start_clicked();

    void on_pushBTN_Stop_clicked();
};

#endif // MAINWINDOW_H
